import 'package:shared_preferences/shared_preferences.dart';

import '../helper/helper.dart';
import '../model/auth.dart';
import '../repos/exception_handlers.dart';
import 'auth_service.dart';

class StorageService{

  removeAuthSharedPreferences() async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    prefs.remove('name');
    prefs.remove('id');
    prefs.remove('avatar');
    prefs.remove('email');
    prefs.remove('type');

    prefs.remove('loginTime');
    prefs.remove('defaultLanguages');
    prefs.remove('token');
  }

  setSingleStringData(key,data) async{
    SharedPreferences prefs = await SharedPreferences.getInstance();
    prefs.setString(key, data);
  }

  storeAuthSharedPreferences(data) async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    prefs.setString('name', data['name']);
    prefs.setInt('id', data['id']);
    prefs.setString('defaultLanguages', data['defaultLanguages']);
    prefs.setString('avatar', data['avatar']);
    prefs.setString('email', data['email']);
    prefs.setString('loginTime', data['loginTime']);
    prefs.setString('token', data['token']);
  }




  Future<Auth> getAuthUserDataFromStorage() async {
    var user = Auth();
    SharedPreferences prefs = await SharedPreferences.getInstance();
    user.id = prefs.getInt('id');
    user.name = prefs.getString('name');
    user.type = prefs.getString('type');
    user.loginTime = prefs.getString('loginTime');
    user.email = prefs.getString('email');
    user.avatar = prefs.getString('avatar');
    user.defaultLanguages = prefs.getString('defaultLanguages');
    user.token = prefs.getString('token');

    return user;
  }


  Future<bool?> authUserDataFromServer() async {
    try{
      SharedPreferences prefs = await SharedPreferences.getInstance();
      if (prefs.containsKey('token')) {
        var authService = AuthService();
        await authService.checkAuth();
        return true;
      }
      return false;
    }catch(e){
      removeAuthSharedPreferences();
      var message = ExceptionHandlers().getExceptionString(e);
      showMessage(message);
      return false;
    }

  }


  getUserId() async{
    SharedPreferences prefs = await SharedPreferences.getInstance();
    return prefs.getInt('id');
  }



  Future<String> getToken() async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    return prefs.getString('token').toString();
  }



  Future<bool?> isAuthInLocal() async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    if (prefs.containsKey('token') && prefs.getString('token') != null) {
      return true;
    }else{
      return false;
    }
  }

  setSingleValue(String key,String value) async{
    SharedPreferences prefs = await SharedPreferences.getInstance();
    return prefs.setString(key, value);
  }

  setBoolValue(bool value, String key) async{
    SharedPreferences prefs = await SharedPreferences.getInstance();
    return prefs.setBool(key, value);
  }

  removeSingleValue(String key) async{
    SharedPreferences prefs = await SharedPreferences.getInstance();
    /*if have remove first*/
    if(await getSingleValues(key) != null){
      return prefs.remove(key);
    }
  }

  removeSingleBoolValue(String key) async{
    SharedPreferences prefs = await SharedPreferences.getInstance();
    /*if have remove first*/
    if(await getSingleBoolValues(key) != null){
      return prefs.remove(key);
    }
  }

  Future<String?> getSingleValues(String key) async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    return prefs.getString(key);
  }

  Future<bool?> getSingleBoolValues(String key) async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    return prefs.getBool(key);
  }


}