import 'package:flutter/cupertino.dart';
import 'package:top_news_app/screen/authors_screen.dart';
import 'package:top_news_app/screen/bookmark_screen.dart';
import 'package:top_news_app/screen/email_login_screen.dart';
import 'package:top_news_app/screen/main_screen.dart';
import 'package:top_news_app/screen/register_screen.dart';
import 'package:top_news_app/screen/setting_screen.dart';
import 'package:top_news_app/screen/splash_screen.dart';


class AppRoutes {
  static Route<dynamic> appRoutes(RouteSettings routeSettings){

    switch(routeSettings.name){
      case '/authors':
        return CupertinoPageRoute(builder: (_) => const AuthorsScreen());
      case '/email-login':
        return CupertinoPageRoute(builder: (_) => const EmailLoginScreen());
      case '/sign-up':
        return CupertinoPageRoute(builder: (_) => const RegistrationScreen());
      case '/setting-screen':
        return CupertinoPageRoute(builder: (_) => const SettingScreen());
      case '/splash':
        return CupertinoPageRoute(builder: (_) => const SplashScreen());
      case '/main-screen':
        return CupertinoPageRoute(builder: (_) => const MainScreen());
      case '/bookMark-screen':
        return CupertinoPageRoute(builder: (_) => const BookMarkScreen());
      default:
        return CupertinoPageRoute(builder: (_) => const SplashScreen());

    }
  }
}