import 'package:flutter/cupertino.dart';
import 'package:top_news_app/model/Ads.dart';
import 'package:top_news_app/model/Author.dart';
import 'package:top_news_app/model/Polling.dart';
import '../helper/helper.dart';
import '../model/Article.dart';
import '../model/Comment.dart';
import '../model/notify.dart';
import '../model/post_category.dart';
import '../services/article_service.dart';
import '../services/auth_service.dart';


class ArticleProvider extends ChangeNotifier{
  final _articleService = ArticleService();


  Future<List<ArticleData>?> getFeedPosts(page) async {
    Article article;
    var response = await _articleService.getFeedPosts(page);
    Map parse = response;
    article = Article.fromJson(parse);
    return article.data;
  }

  Future<List<ArticleData>?> getCategoryPosts(categoryId,page) async {
    Article article;
    var response = await _articleService.getCategoryPosts(categoryId, page);
    Map parse = response;
    article =Article.fromJson(parse);
    return article.data;
  }

  Future<List<ArticleData>?> getTrendingPosts() async {
    Article article;
    var response = await _articleService.getTrendingPosts();
    Map parse = response;
    article = Article.fromJson(parse);
    return article.data;
  }

  Future<List<ArticleData>?> getTopPosts() async {
    Article article;
    var response = await _articleService.getTopPosts();
    Map parse = response;
    article = Article.fromJson(parse);
    return article.data;
  }

  Future<List<ArticleData>?> getBrakingPosts() async {
    Article article;
    var response = await _articleService.getTrendingPosts();
    Map parse = response;
    article = Article.fromJson(parse);
    return article.data;
  }


  Future<List<ArticleData>?> getRelatedPost(categoryId) async {
    Article article;
    var response = await _articleService.getRelatedPost(categoryId);
    Map parse = response;
    article = Article.fromJson(parse);
    return article.data;
  }

  Future<List<ArticleData>?> bookmarkPosts() async {
    Article article;
    var response = await _articleService.bookmarkPosts();
    Map parse = response;
    article = Article.fromJson(parse);
    return article.data;
  }




  Future<ArticleData> getPostDetails(id) async {
    ArticleData data;
    var response = await _articleService.getPostDetails(id);
    Map parse = response;
    data = ArticleData.fromJson(parse['data']);
    return data;
  }

  Future<List<PollingData>?> getRandomPolling(positions) async {
    Polling polling;
    var response = await _articleService.getRandomPolling(positions);
    Map parse = response;
    polling = Polling.fromJson(parse);
    return polling.pollingData;
  }

  Future<List<PollingData>?> getAllPolling() async {
    Polling polling;
    var response = await _articleService.getAllPolling();
    Map parse = response;
    polling = Polling.fromJson(parse);
    return polling.pollingData;
  }

  Future<List<ArticleData>?> getSliderPosts() async {
    Article article;
    var response = await _articleService.getSliderPosts();
    Map parse = response;
    article = Article.fromJson(parse);
    return article.data;
  }

  Future<List<PostCategoryData>?> getPostCategories(type) async {
    PostCategory category;
    var response = await _articleService.getPostCategories(type);
    Map parse = response;
    category = PostCategory.fromJson(parse);
    return category.postCategoryData;
  }



  Future<List<AdsData>?> getAds() async {
    Ads ads;
    var response = await _articleService.getAds();
    Map parse = response;
    ads = Ads.fromJson(parse);
    return ads.adsData;
  }

  Future<AdsData> getSingleAds(id) async {
    AdsData data;
    var response = await _articleService.getSingleAds(id);
    Map parse = response;
    data = AdsData.fromJson(parse['data']);
    return data;
  }

  Future<PollingData> getSinglePolling(id) async {
    PollingData data;
    var response = await _articleService.getSinglePoll(id);
    Map parse = response;
    data = PollingData.fromJson(parse['data']);
    return data;
  }


  Future<List<AuthorData>?> getAuthors() async {
    Author author;
    var response = await _articleService.getAuthors();
    Map parse = response;
    author = Author.fromJson(parse);
    return author.authorData;
  }


  Future<AuthorData> getAuthor(id) async {
    AuthorData author;
    var response = await _articleService.getAuthor(id);
    Map parse = response;
    author = AuthorData.fromJson(parse['data']);
    return author;
  }


  Future<List<ArticleData>?> getAuthorPosts(id,page) async {
    Article article;
    var response = await _articleService.getAuthorPosts(id,page);
    Map parse = response;
    article = Article.fromJson(parse);
    return article.data;
  }

  Future<bool> bookMarking(id) async {
    var result = await _articleService.bookMark(id);

    if(result.containsKey('message')){
      showMessage(result['message']);
    }

    return result['result'];
  }

  Future<void> views(id) async {
    await _articleService.views(id);
  }




  Future<List<Data>?> getNotification() async {
    var authService = AuthService();
    Notify notify;
    var response = await  authService.notifications();
    Map parse = response;
    notify = Notify.fromJson(parse);
    return notify.data;
  }


   commentStore(postId,message) async{
    return await _articleService.commentStore(postId,message);
  }


  Future<List<CommentData>?> getCommentData(id,page) async {
    Comment comment;
    var response = await _articleService.getComments(id,page);
    Map parse = response;
    comment = Comment.fromJson(parse);
    return comment.commentData;
  }
}