class CategoryModel {
  List<Data>? data;

  CategoryModel({
       this.data});

  CategoryModel.fromJson(dynamic json) {
    if (json["data"] != null) {
      data = [];
      json["data"].forEach((v) {
        data?.add(Data.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    var map = <String, dynamic>{};
    if (data != null) {
      map["data"] = data?.map((v) => v.toJson()).toList();
    }
    return map;
  }

}

class Data {
  int? id;
  String? name;
  List<Parent>? parent;

  Data({
       this.id,
       this.name,
       this.parent});

  Data.fromJson(dynamic json) {
    id = json["id"];
    name = json["name"];
    if (json["parent"] != null) {
      parent = [];
      json["parent"].forEach((v) {
        parent?.add(Parent.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    var map = <String, dynamic>{};
    map["id"] = id;
    map["name"] = name;
    if (parent != null) {
      map["parent"] = parent?.map((v) => v.toJson()).toList();
    }
    return map;
  }

}

class Parent {
  int? id;
  String? name;
  List<Child>? child;

  Parent({
       this.id,
       this.name,
       this.child});

  Parent.fromJson(dynamic json) {
    id = json["id"];
    name = json["name"];
    if (json["child"] != null) {
      child = [];
      json["child"].forEach((v) {
        child?.add(Child.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    var map = <String, dynamic>{};
    map["id"] = id;
    map["name"] = name;
    if (child != null) {
      map["child"] = child?.map((v) => v.toJson()).toList();
    }
    return map;
  }

}

class Child {
  int? id;
  String? name;

  Child({
       this.id,
       this.name});

  Child.fromJson(dynamic json) {
    id = json["id"];
    name = json["name"];
  }

  Map<String, dynamic> toJson() {
    var map = <String, dynamic>{};
    map["id"] = id;
    map["name"] = name;
    return map;
  }

}