
import 'package:firebase_core/firebase_core.dart';
import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:flutter/material.dart';
import 'package:top_news_app/firebase_options.dart';
import 'package:top_news_app/providers/theme_provider.dart';
import 'package:top_news_app/route/routes.dart';
import 'package:provider/provider.dart';
import 'package:flutter_localizations/flutter_localizations.dart';
import 'helper/helper.dart';
import 'localization/app_localization.dart';
import 'localization/localization.dart';



Future<void> _messageHandler(RemoteMessage message) async {

}

void main() async  {
  WidgetsFlutterBinding.ensureInitialized();
  await Firebase.initializeApp(
    options: DefaultFirebaseOptions.currentPlatform,
  );
  FirebaseMessaging.onBackgroundMessage(_messageHandler);
  runApp(MultiProvider(
    providers: [
      ChangeNotifierProvider(create: (_) => ThemeProvider()),
    ],
    child: const MyApp(),
  ));
}

class MyApp extends StatefulWidget {
  const MyApp({super.key});

  static void setLocale(BuildContext context, Locale local) {
    _MyAppState? localState = context.findAncestorStateOfType<_MyAppState>();
    localState!.setLocale(local);
  }

  @override
  State<MyApp> createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {

  Locale? _locale;
  setLocale(Locale locale) {
    setState(() {
      _locale = locale;
    });
  }

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    getLocale().then((locale) {
      setState(() {
        _locale = locale;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return Consumer<ThemeProvider>(builder: (context,provider,child){
      if(_locale == null){
        return MaterialApp(
          title: appsName,
          debugShowCheckedModeBanner: false,
          theme: ThemeData(
            primarySwatch: primaryColors,
            brightness: Brightness.light,
          ),
          darkTheme: ThemeData(
            primarySwatch: primaryColors,
            brightness: Brightness.dark,
          ),
          themeMode: provider.themeMode,
          onGenerateRoute: AppRoutes.appRoutes,
          initialRoute: '/splash',
        );
      }else{
        return MaterialApp(
          title: appsName,
          debugShowCheckedModeBanner: false,
          locale: _locale,
          supportedLocales: const [
            Locale('en', 'US'),
            Locale("es", "ES"),
            Locale("fr", "FR"),
            Locale("hi", "HI"),
            Locale("bn", "BN"),
            Locale("id", "ID"),
          ],
          localizationsDelegates: const [
            AppLocalization.delegate,
            GlobalMaterialLocalizations.delegate,
            GlobalWidgetsLocalizations.delegate,
            GlobalCupertinoLocalizations.delegate,
          ],
          localeResolutionCallback: (deviceLocale, supportedLocals) {
            for (var locale in supportedLocals) {
              if (locale.languageCode == deviceLocale!.languageCode &&
                  locale.countryCode == deviceLocale.countryCode) {
                return deviceLocale;
              }
            }
            return supportedLocals.first;
          },
          theme: ThemeData(
            primarySwatch: primaryColors,
            brightness: Brightness.light,
          ),
          darkTheme: ThemeData(
            primarySwatch: primaryColors,
            brightness: Brightness.dark,
          ),
          themeMode: provider.themeMode,
          onGenerateRoute: AppRoutes.appRoutes,
          initialRoute: '/splash',
        );
      }
    });


  }
}
