import 'package:flutter/material.dart';
import 'package:top_news_app/helper/helper.dart';
import 'package:top_news_app/helper/image_cached.dart';
import 'package:top_news_app/model/Article.dart';
import 'package:top_news_app/screen/author_post_screens.dart';
import 'package:top_news_app/screen/category_ways_post_list_screen.dart';
import 'package:google_fonts/google_fonts.dart';
import '../providers/article_provider.dart';
import '../screen/news_details_screen.dart';
import '../services/storage_service.dart';

class NewsCardWidgetTransparentOne extends StatefulWidget {
  final ArticleData post;
  const NewsCardWidgetTransparentOne({super.key, required this.post});
  @override
  State<NewsCardWidgetTransparentOne> createState() => _NewsCardWidgetTransparentOneState();

}

class _NewsCardWidgetTransparentOneState extends State<NewsCardWidgetTransparentOne> {

  bool isAuth = false;
  var storage = StorageService();
  bool isBookMark = false;
  var articleProvider = ArticleProvider();


  bookMark() {
    if(!isAuth){
      dialogLogin(context);
    }else{
      storeBookMark();
    }

  }

  storeBookMark() async{
    try{
      isBookMark =  await articleProvider.bookMarking(widget.post.postId);
    } catch (e) {
      rethrow;
    }

    setState(() {

    });
  }

  checkAuth() async {
    isAuth = (await storage.isAuthInLocal())!;
    setState(() {
      isBookMark = widget.post.bookmark!;
    });
  }

  @override
  void initState()  {

    super.initState();
    checkAuth();
  }

  @override
  Widget build(BuildContext context) {
    Size size = MediaQuery.of(context).size;
    return SizedBox(
      height: 260,
      child: Card(
        elevation: 3,
        shape: RoundedRectangleBorder(
          borderRadius: BorderRadius.circular(12),
          //set border radius more than 50% of height and width to make circle
        ),
        semanticContainer: true,
        clipBehavior: Clip.antiAliasWithSaveLayer,
        child: Stack(
          children: [
            Hero(
              tag: 'post-${widget.post.randomNumber}',
              child: ClipRRect(
                  borderRadius: BorderRadius.circular(8),
                  child:ImageCached(image: '${widget.post.thumbnail}',
                    width: size.width,
                    height: 260,
                    fit: BoxFit.cover, blur: false,)
              ),
            ),

            Positioned(
                bottom:5,
                child: Container(
                    width: size.width -14,
                    margin: const EdgeInsets.all(4),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Row(
                          crossAxisAlignment: CrossAxisAlignment.center,
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            GestureDetector(
                              onTap: (){
                                Navigator.push(context, MaterialPageRoute(builder: (context)=>CategoryWaysPostListScreen(title: '${widget.post.categoriesName?[0]}', id: '${widget.post.categoriesId?[0]}',)));
                              },
                              child: Card(
                                color: Colors.white,
                                shape: RoundedRectangleBorder(
                                  borderRadius: BorderRadius.circular(8),
                                ),
                                child: Padding(
                                  padding: const EdgeInsets.symmetric(vertical: 4,horizontal: 8),
                                  child: Text(
                                    '${widget.post.categoriesName?[0]}',
                                    style: GoogleFonts.robotoSerif(
                                        fontWeight: FontWeight.w400,
                                        fontSize: 12,
                                        color: primaryColors
                                    ),
                                  ),
                                ),
                              ),
                            ),
                          ],
                        ),
                        GestureDetector(
                          onTap: (){
                            Navigator.push(context, MaterialPageRoute(builder: (context)=>NewsDetailsScreen(data: widget.post,)));
                          },
                          child: Text(
                            '${widget.post.title}',
                            maxLines: 2,
                            textAlign: TextAlign.justify,
                            style: GoogleFonts.robotoSerif(
                                color: Colors.white,
                                fontSize: 16,
                                fontWeight: FontWeight.w500
                            ),
                          ),
                        ),
                        customSizeBox(5),
                        Row(
                          mainAxisSize: MainAxisSize.max,
                          mainAxisAlignment:
                          MainAxisAlignment.spaceBetween,
                          crossAxisAlignment:
                          CrossAxisAlignment.center,
                          children: [
                            GestureDetector(
                              onTap: (){
                                Navigator.push(context, MaterialPageRoute(builder: (context)=>AuthorPostScreens(name: '${widget.post.authorName}', id: '${widget.post.authorId}', image: '${widget.post.authorAvatar}',randomNumber: widget.post.randomNumber ?? 0,)));
                              },
                              child: Row(
                                mainAxisSize: MainAxisSize.max,
                                children: [
                                  Hero(
                                    tag: 'avatar-${widget.post.randomNumber}',
                                    child: Container(
                                      width: 20,
                                      height: 20,
                                      clipBehavior:
                                      Clip.antiAlias,
                                      decoration: const BoxDecoration(
                                        shape: BoxShape.circle,
                                      ),
                                      child: Image.network(
                                        '${widget.post.authorAvatar}',
                                        fit: BoxFit.cover,
                                      ),
                                    ),
                                  ),
                                  Padding(
                                    padding: const EdgeInsets.symmetric(horizontal: 10),
                                    child: Text(
                                      '${widget.post.authorName}',
                                      style: GoogleFonts.robotoSerif(
                                          fontWeight: FontWeight.w500,
                                          color: Colors.white
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                            ),
                            Padding(
                              padding: const EdgeInsets.symmetric(horizontal: 10),
                              child: Text(
                                '${widget.post.approvedAt}',
                                style: GoogleFonts.robotoSerif(
                                    fontWeight: FontWeight.w500,
                                    color: Colors.white
                                ),
                              ),
                            ),
                          ],
                        ),

                      ],
                    ))),
             Positioned(
                top: 5,
                right: 5,
                child: GestureDetector(
                  onTap: (){
                    bookMark();
                  },
                  child: Card(
                    elevation: elevation,
                    color: isBookMark ? primaryColors : Colors.white,
                    child: Padding(
                      padding: const EdgeInsets.all(3.0),
                      child: Icon(
                        Icons.bookmark_border,
                        size: 24,
                        color: isBookMark ? Colors.white : primaryColors,
                      ),
                    ),
                  ),
                ))
          ],
        ),
      ),
    );
  }
}
