import 'package:flutter/material.dart';
import 'package:top_news_app/helper/helper.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:top_news_app/repos/exception_handlers.dart';
import 'package:top_news_app/services/auth_service.dart';
import '../localization/localization.dart';

class ResetPassword3rd extends StatefulWidget {
  final String code;
  final String email;
  const ResetPassword3rd({super.key,required this.code,required this.email});

  @override
  State<ResetPassword3rd> createState() => _ResetPassword3rdState();
}

class _ResetPassword3rdState extends State<ResetPassword3rd> {
  bool obscureText = true;

  var password = TextEditingController();
  var confirmPassword = TextEditingController();
  String code = '';
  bool isLoading = false;
  String email = '';

  passwordReset(context) async {
    setState(() {
      isLoading = true;
    });
    try{

      if(password.text.length < 4){
        showMessage(getTranslated(context, 'Password Is very small') ?? 'Password Is very small');
      }else if (password.text != confirmPassword.text){
        showMessage(getTranslated(context, 'Confirm Password ate not matched') ?? 'Confirm Password ate not matched');
      }else{
        var authService = AuthService();
        var response = await authService.forgetPasswordThree(email,code,password.text);
        var result =  processResponse(response);
        if(result.containsKey('message')){
          showMessage(result['message']);
        }
        if(result['result'] == true){
        }else{
          Navigator.pushNamed(context, 'login');
        }

      }

    } catch (e) {

      var message = ExceptionHandlers().getExceptionString(e);
      showMessage(message);

    }

    setState(() {
      isLoading = false;
    });

  }


  @override
  void initState() {
    super.initState();
    code =  widget.code;
    email =  widget.email;
  }
  @override
  Widget build(BuildContext context) {
    Size size = MediaQuery.of(context).size;
    return SafeArea(
      child: Scaffold(
        resizeToAvoidBottomInset: false,
        appBar: AppBar(
          leading: Container(),
          backgroundColor: Theme.of(context).scaffoldBackgroundColor,
          elevation: 0,
          actions: [IconButton(icon: Icon(Icons.cancel_outlined,color: Theme.of(context).iconTheme.color,), onPressed: (){
            Navigator.pushReplacementNamed(context, '/main-screen');
          })],
        ),
        body: SingleChildScrollView(
          scrollDirection: Axis.vertical,
          padding: const EdgeInsets.all(12),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.spaceEvenly,
            children: <Widget>[
              Padding(
                padding: const EdgeInsets.symmetric(horizontal: 40),
                child: Column(
                  children: <Widget>[
                    Container(
                      height: size.height / 4,
                      decoration:  BoxDecoration(
                        image: DecorationImage(
                            image: Theme.of(context).brightness == Brightness.dark ?  AssetImage(darkLogo) :  AssetImage(lightLogo)),
                      ),
                    ),
                    const SizedBox(
                      height: 10,
                    ),
                    Text(
                      getTranslated(context, 'Reset Password') ?? "Reset Password",
                      style: GoogleFonts.robotoMono(
                          fontSize: 24, fontWeight: FontWeight.bold),
                    ),
                    const SizedBox(
                      height: 10,
                    ),
                    Text(
                      getTranslated(context, 'Enter Your New Password') ?? "Enter Your New Password",
                      style: GoogleFonts.robotoMono(fontSize: 12),
                      textAlign: TextAlign.center,
                    ),
                    const SizedBox(
                      height: 10,
                    ),
                  ],
                ),
              ),
              Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: <Widget>[
                  Text(
                    getTranslated(context, 'New Password') ?? 'New Password',
                    style: GoogleFonts.robotoMono(
                        fontSize: 14, fontWeight: FontWeight.w400),
                  ),
                  const SizedBox(
                    height: 5,
                  ),
                  TextField(
                    controller: password,
                    obscureText: obscureText,
                    decoration: InputDecoration(
                      hintText: getTranslated(context, 'Enter your new password') ?? 'Enter your new password',
                      hintStyle: GoogleFonts.robotoSerif(
                          fontSize: 14, color: Colors.grey),
                      suffixIcon: IconButton(
                        icon: Icon(
                          // Based on passwordVisible state choose the icon
                          !obscureText
                              ? Icons.visibility
                              : Icons.visibility_off,
                          color: Colors.grey,
                        ),
                        onPressed: () {
                          // Update the state i.e. toogle the state of passwordVisible variable
                          setState(() {
                            obscureText = !obscureText;
                          });
                        },
                      ),
                      contentPadding: const EdgeInsets.symmetric(
                          vertical: 0, horizontal: 10),
                      enabledBorder: const OutlineInputBorder(
                          borderRadius:
                              BorderRadius.all(Radius.circular(5)),
                          borderSide: BorderSide(color: Colors.grey)),
                      border: const OutlineInputBorder(
                          borderRadius:
                              BorderRadius.all(Radius.circular(5)),
                          borderSide: BorderSide(color: Colors.grey)),
                    ),
                  ),
                  const SizedBox(
                    height: 30,
                  ),
                  Text(
                    getTranslated(context, 'Confirm Password') ?? 'Confirm Password',
                    style: GoogleFonts.robotoMono(
                        fontSize: 14, fontWeight: FontWeight.w400),
                  ),
                  const SizedBox(
                    height: 5,
                  ),
                  TextField(
                    controller: confirmPassword,
                    obscureText: obscureText,
                    decoration: InputDecoration(
                      hintText: getTranslated(context, 'Enter your confirm password') ?? 'Enter your confirm password',
                      hintStyle: GoogleFonts.robotoSerif(
                          fontSize: 14, color: Colors.grey),
                      suffixIcon: IconButton(
                        icon: Icon(
                          // Based on passwordVisible state choose the icon
                          !obscureText
                              ? Icons.visibility
                              : Icons.visibility_off,
                          color: Colors.grey,
                        ),
                        onPressed: () {
                          // Update the state i.e. toogle the state of passwordVisible variable
                          setState(() {
                            obscureText = !obscureText;
                          });
                        },
                      ),
                      contentPadding: const EdgeInsets.symmetric(
                          vertical: 0, horizontal: 10),
                      enabledBorder: const OutlineInputBorder(
                          borderRadius:
                              BorderRadius.all(Radius.circular(5)),
                          borderSide: BorderSide(color: Colors.grey)),
                      border: const OutlineInputBorder(
                          borderRadius:
                              BorderRadius.all(Radius.circular(5)),
                          borderSide: BorderSide(color: Colors.grey)),
                    ),
                  ),
                  const SizedBox(
                    height: 30,
                  ),
                ],
              ),
              customSizeBox(30),
              GestureDetector(
                onTap: () {
                  passwordReset(context);
                },
                child: Container(
                    height: 45,
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(5.0),
                      color: primaryColorsAccent,
                    ),
                    child: isLoading ? Center(
                        child: Text(
                          '${getTranslated(context, 'Processing') ?? 'Processing'}....',
                          style: buttonTextStyle,
                        )) : Center(
                        child: Text(
                          getTranslated(context, 'Reset Password') ?? 'Reset Password',
                          style: buttonTextStyle,
                        ))),
              ),

              const SizedBox(
                height: 10,
              ),
            ],
          ),
        ),
      ),
    );
  }
}
