
import 'package:flutter/material.dart';
import 'package:top_news_app/helper/custom_appbar.dart';
import 'package:top_news_app/helper/helper.dart';
import 'package:top_news_app/helper/image_cached.dart';
import 'package:top_news_app/localization/localization.dart';
import 'package:top_news_app/providers/article_provider.dart';
import 'package:top_news_app/screen/author_post_screens.dart';
import 'package:google_fonts/google_fonts.dart';
import '../model/Author.dart';

class AuthorsScreen extends StatefulWidget {
  const AuthorsScreen({super.key});

  @override
  State<AuthorsScreen> createState() => _AuthorsScreenState();
}

class _AuthorsScreenState extends State<AuthorsScreen> {
  late bool _isLoading = true;
  var articleProvider = ArticleProvider();
  List<AuthorData> data= [];
  

   loadingEffect() async {
     try{
       data = (await articleProvider.getAuthors())!;
     } catch (e) {
       rethrow;
     }

    setState(() {
      _isLoading = false;
    });
  }

  @override
  void initState() {
    super.initState();
    loadingEffect();
  }


  @override
  Widget build(BuildContext context) {
    Size size = MediaQuery.of(context).size;
    return SafeArea(
      child: RefreshIndicator(
        onRefresh:  () async {
          return await loadingEffect();
        },
        child: Scaffold(
            appBar: customAppBar(getTranslated(context, 'Authors') ?? 'Authors', 'back',context),
            body:  _isLoading
                ? const Center(
              child: CircularProgressIndicator(),
            )
                : ListView.builder(
              itemCount: data.length,
            itemBuilder: (context,int index){
                return Card(
                  elevation: elevation,
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.circular(8),
                  ),
                  child: Padding(
                    padding: const EdgeInsets.symmetric(horizontal: 10,vertical: 2),
                    child: Row(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: [
                        SizedBox(
                          width: 110,
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.center,
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              Container(
                                decoration: const BoxDecoration(
                                  shape: BoxShape.circle,
                                ),
                                child:  SizedBox(
                                  height: 100,
                                  width: 100,
                                  child: Hero(
                                    tag: 'author-${data[index].randomNumber}',
                                    child: ImageCached(
                                        blur: false,
                                        height: 100, width: 100, image: data[index].avatar,fit: BoxFit.fill),
                                  ),
                                ),
                              ),
                              customSizeBox(10),
                            ],
                          ),
                        ),
                        Padding(
                          padding: const EdgeInsets.only(left: 10),
                          child: SizedBox(
                            width: size.width - 150,
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                Text(
                                  '${data[index].name}',
                                  style:  GoogleFonts.roboto(
                                      fontWeight: FontWeight.w700, fontSize: 18),
                                ),
                                customSizeBox(8),
                                Text(
                                  data[index].bio ?? '',
                                  maxLines: 2,
                                  style:  GoogleFonts.roboto(
                                      fontWeight: FontWeight.w400, fontSize: 14),
                                ),
                                customSizeBox(5),
                                Align(
                                  alignment: Alignment.bottomRight,
                                  child: GestureDetector(
                                    onTap: (){
                                      Navigator.push(context, MaterialPageRoute(builder: (context)=>AuthorPostScreens(name: '${data[index].name}', id: '${data[index].id}', image: '${data[index].avatar}', randomNumber: data[index].randomNumber!,)));
                                    },
                                    child: Container(
                                      padding: const EdgeInsets.all(8),
                                      decoration: BoxDecoration(
                                          borderRadius: const BorderRadius.all(Radius.circular(6)),
                                          border: Border.all(color: Colors.grey)
                                      ),
                                      child: Text(getTranslated(context, 'See Details') ?? 'See Details' ,style: GoogleFonts.robotoSerif(fontWeight: FontWeight.w600,fontSize: 12),),
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ),
                      ],
                    ),
                  ),
                );
            }),
            ),
      ),
    );
  }
}
